unit UTabela;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  DB, ADODB, Dialogs,
  {}
  DataModule,
  URekord;


Type

MTabela = class(TObject)
protected
   ilRek         : Longint;
   sql_txt       : String;
   ADOConnection : TADOConnection;	// tylko wskanik, nie usuwa

public
   // local query
	LQ :   TADOQuery;

   function    Eof() : Boolean;
   procedure   First();
   procedure   Next();
   procedure   Close();
   function    RecordCount() : Longint;

   // wykonaj zapytanie SQL typu Select - zwracajce kursor
   function    Open() : Boolean;
   function    ExecSQL(WlaczycTransakcje : Boolean = false) : Boolean;


   function    DajWszystko() : Boolean; virtual; abstract;
	function    Edit(rec : MRekord) : Boolean; virtual; abstract;
	function    Insert(rec : MRekord) : Boolean; virtual; abstract;
   function    Delete(id : Integer) : Boolean; virtual; abstract;
   procedure   GetRec(); virtual; abstract;

	constructor Create(); virtual;
	destructor  Destroy(); override;
end;

implementation
{------------------------------------------------------------------------------}
constructor MTabela.Create();
begin
	// tylko wskazanie na komponent z DataModule
	ADOConnection     := DM.ADOConnection1;

   LQ                := TADOQuery.Create(Nil);
   LQ.Name           := 'LOCAL_ADOQUERY';
   LQ.Connection     := ADOConnection;
	LQ.CommandTimeout := 60;
   LQ.SQL.Clear();
   sql_txt           := '';
end;

destructor MTabela.Destroy();
begin
   LQ.Close();
	FreeAndNil(LQ);
	
	inherited;
end;

function MTabela.Eof() : Boolean;
begin
	Result := LQ.Eof;
end;

procedure MTabela.First();
begin
   LQ.First();
end;

procedure MTabela.Next();
begin
   LQ.Next();
end;

procedure MTabela.Close();
begin
   LQ.Close();
end;

function MTabela.RecordCount() : LongInt;
begin
	Result := LQ.RecordCount;
end;

function MTabela.Open() : Boolean;
var
	ret : Boolean;

begin
	(*
   SQL text jest ju ustawiony, parametry rwnie
   otwieram kursor oraz ustawiam RecordCount
   *)

	ret := true;

   ilRek := 0;           // wynik operacji Select - ile rekordw go spenia

   try
      Application.ProcessMessages();
      LQ.Open();
      ilRek := RecordCount();
	except
      ret := false;
      ShowMessage('Bd wykonania instrukcji Open');
   end;

	Result := ret;
end;

function MTabela.ExecSQL(WlaczycTransakcje : Boolean) : Boolean;
var
	trwa_transakcja : Boolean;
	ret             : Boolean;

begin
	trwa_transakcja := false;
   ret             := true;

   // SQL text jest ju ustawiony, parametry rwnie
   trwa_transakcja := ADOConnection.InTransaction;

   try
      if WlaczycTransakcje then
      begin
         if not trwa_transakcja then
         begin
            ADOConnection.BeginTrans();
         end;
      end;

      LQ.ExecSQL();


      if WlaczycTransakcje then
      begin
         ADOConnection.CommitTrans();
      end;
	except
      if WlaczycTransakcje then
      begin
         ADOConnection.RollbackTrans();
         ShowMessage('Transakcja wycofana');
      end;
      ret := false;

      ShowMessage('Bd wykonania funkcji ExecSQL');
   end;

	Result := ret;
end;

end.

